var DEFAULT_CONTINENT = 1;
var DEFAULT_CITY      = 90;

var TvShow = Class.create();

TvShow.prototype =
{
initialize: function(url, title, continent, city)
{
  this.quickInfoUrl = url + "?embed=nextepisode";
  //this.quickInfoUrl = url + "?embed[]=nextepisode&embed[]=previousepisode";
    this.url                 = url;
    this.title               = title;
    this.front_id            = 'front-' + title;
    this.back_id             = 'back-'  + title;
	  this.special             = "";
    this.destructed          = false;
    this.ajax_request        = null;
    this.time_is_known       = false;
    this.continent           = null;
    this.city                = null;
    this.adjust_for_timezone = true;

    if (continent != null)
    {
        this.continent = parseInt(continent);
    }

    if (city != null)
    {
        this.city = parseInt(city);
    }

    this.refreshTimezoneOffset();

    var back_ul = $('your-tv-shows-inner');

    var title = this.title;

    if (title.length > 32)
    {
        title = title.substr(0, 31).replace(/\s*$/, '') + '…';
    }

    // make the back list item
    var back_li = document.createElement("li");
    back_li.id = this.back_id;

    // add a timezone button to the back list item
    var back_li_tz_button = document.createElement("div");
    back_li_tz_button.id = this.back_id + '-tz-button';
    Element.addClassName(back_li_tz_button, 'timezone-button');
    back_li.appendChild(back_li_tz_button);

    // add the tv show title to the back list item
    var back_li_title = document.createElement("div");
    back_li_title.innerText = title;
    back_li_title.id = this.back_id + '-title-text';
    Element.addClassName(back_li_title, 'back-li-title');
    back_li.appendChild(back_li_title);

    //if(!back_ul.hasChildNodes() || back_ul.lastChild.id < back_li.id)
    //{
      back_ul.appendChild(back_li);
    //}
    //else
    //{
    //  var listpos = 0;
    //  while (back_ul.childNodes[listpos].id < back_li.id && listpos < back_ul.length)
    //  {
    //    listpos++;
    //  }
    //  back_ul.insertBefore(back_li,back_ul.childNodes[listpos]);
    //}



    Event.observe(this.back_id + '-title-text', 'click', function() { widget.openURL(this.episode_url)});
    Event.observe(this.back_id + '-tz-button', 'click', this.eventTzClicked.bind(this));
    Event.observe(this.back_id, 'click', this.eventClicked.bind(this));

    this.refreshTimezoneButton();
},

adjustForTimezone: function(state)
{
    this.adjust_for_timezone = state;
},

refresh: function()
{
    this.ajax_request =
        new AjaxRequest(this.quickInfoUrl, this.processQuickInfo.bind(this));

    schedulePending();
},

destruct: function()
{
    var front = $(this.front_id);
    var back  = $(this.back_id);

    if (front)
    {
        Element.remove(front);
    }

    if (this.ajax_request)
    {
        this.ajax_request.abort();
        this.ajax_request = null;

        // signal that the TvShow has arrived - despite being aborted
        scheduleReady();
    }

    Element.remove(back);

    this.destructed = true;
},

getTitle: function()
{
    return this.title;
},

getSortTitle: function()
{
    return this.title.replace("The ", "").toLowerCase();
},

getUrl: function()
{
    return this.url;
},

timeIsKnown: function()
{
    return this.time_is_known;
},

getSelected: function()
{
    return Element.hasClassName(this.back_id, 'selected-tv-show');
},

setSelected: function(state)
{
    if (state)
    {
        Element.addClassName(this.back_id, 'selected-tv-show');
    }
    else if (this.getSelected())
    {
        Element.removeClassName(this.back_id, 'selected-tv-show');

        // close the timezone dialog if it is open
        if ($(this.back_id + '-timezone') != null)
        {
            this.refreshTimezoneButton();
            Element.remove(this.back_id + '-timezone');
        }
    }
},

refreshTimezoneButton: function()
{
    var disabled_class_name = 'timezone-button-disabled';
    var class_name          = 'timezone-button-set';
    var class_name_def      = 'timezone-button-default';
    var id                  = this.back_id + '-tz-button';

    if (this.adjust_for_timezone)
    {
        if (Element.hasClassName(id, disabled_class_name))
        {
            Element.removeClassName(id, disabled_class_name);
        }
    }
    else
    {
        if (!Element.hasClassName(id, disabled_class_name))
        {
            Element.addClassName(id, disabled_class_name);
            return;
        }
    }

    if (this.continent != null && this.city != null)
    {
      if(this.timezone_offset != 0 && (this.continent != DEFAULT_CONTINENT || this.city != DEFAULT_CITY))
      {
        if (!Element.hasClassName(id, class_name))
        {
            Element.addClassName(id, class_name);
        }
        if (Element.hasClassName(id, class_name_def))
        {
            Element.removeClassName(id, class_name_def);
        }
        return;
      }
      else if (this.timezone_offset != 0)
       {
        if (!Element.hasClassName(id, class_name_def))
        {
            Element.addClassName(id, class_name_def);
        }
        if (Element.hasClassName(id, class_name))
        {
            Element.removeClassName(id, class_name);
        }
        return;
      }
    }
    else
    {
      if (Element.hasClassName(id, class_name))
      {
        Element.removeClassName(id, class_name);
      }
      if (Element.hasClassName(id, class_name_def))
      {
        Element.removeClassName(id, class_name_def);
      }
    }
},

toXml: function()
{
  if(this.continent && this.city)
  {
    return '<subscription>' +
	         '<title>' + encodeURIComponent(this.title) + '</title>' +
           '<url>' + this.url + '</url>' +
	  	     '<continent>' + this.continent + '</continent>' +
		       '<city>' + this.city + '</city>' +
           '</subscription>';
  }
    return '<subscription>' +
	         '<title>' + encodeURIComponent(this.title) + '</title>' +
		       '<url>' + this.url + '</url>' +
           '</subscription>';
},

eventTzClicked: function()
{
    var tz_id = this.back_id + '-timezone';

    if ($(tz_id) != null)
    {
        this.refreshTimezoneButton();
        Element.remove($(tz_id));
        return;
    }

    if (!this.adjust_for_timezone)
    {
        return;
    }

    var li = $(this.back_id);

    var timezone = document.createElement('div');
    timezone.id = tz_id;

    Element.addClassName(timezone, 'timezone-dialog');

    var continent_select = document.createElement('select');
    var city_select      = document.createElement('select');

    populateContinents(continent_select);
    populateCities(city_select, continents[(this.continent ? this.continent : 0)].cities);

    if(this.continent) continent_select.selectedIndex = this.continent;
    if(this.city) city_select.selectedIndex      = this.city;

    continent_select.id = this.back_id + '-continent-select';
    city_select.id      = this.back_id + '-city-select';

    Element.addClassName(continent_select, 'continent-dropdown');
    Element.addClassName(city_select,      'city-dropdown');

    timezone.appendChild(continent_select);
    timezone.appendChild(city_select);

    li.appendChild(timezone);

    Event.observe(continent_select, 'click', function()
    {
        if (this.continent != continent_select.selectedIndex)
        {
            populateCities(
                city_select,
                continents[continent_select.selectedIndex].cities);

            this.continent = continent_select.selectedIndex;
            this.city      = city_select.selectedIndex;

            this.refreshTimezoneOffset();
            this.refreshTimezoneButton();
        }
    }.bind(this));

    Event.observe(city_select, 'click', function()
    {
        this.city = city_select.selectedIndex;

        this.refreshTimezoneOffset();
        this.refreshTimezoneButton();
    }.bind(this));
},

eventClicked: function()
{
    if (this.getSelected())
    {
        return;
    }

    your_tv_shows.each(function(your_tv_show)
    {
        your_tv_show.setSelected(false);
    })

    this.setSelected(true);

	remove_button.setEnabled(true);
},

processQuickInfo: function(quickInfo)
{
    this.ajax_request = null;

    if (this.destructed)
    {
        // destruct will call scheduleReady - no need to do it here
        return;
    }

    if (quickInfo == "")
    {
        // no data
        scheduleReady();
        return;
    }

    var tv_show_summary = new TvShowParser(quickInfo);


    if(!this.continent || !this.city)
    {
      this.continent = tv_show_summary.getContinent();
      this.city = tv_show_summary.getCity(this.continent);
      this.refreshTimezoneOffset();
      this.refreshTimezoneButton();
    }


    if (tv_show_summary.showAirsNext() == 'Unknown')
    {
        if (tv_show_summary.showStatus() != TvShowStatus.Normal)
        {
            this.special = tvShowStatusToString(tv_show_summary.showStatus());
            this.episode       = " ";
        	  this.episode_id 	 = " ";
        }
        else
        {
            this.special = "TBA";
            this.episode       = "TBA";
    	      this.episode_id 	 = " ";
            this.episode_url   = tv_show_summary.showUrl();
        }

        this.show_url   = tv_show_summary.showUrl();
        this.image   = tv_show_summary.showImage();
        this.summary   = tv_show_summary.airSummary();
        this.shortinfo   = tv_show_summary.showSummary();
        this.network_url   = tv_show_summary.networkUrl();

        this.date          = null;
        this.time_is_known = false;
    }
    else if (tv_show_summary.showAirsNext() == 'TBA')
    {
        if (tv_show_summary.showStatus() != TvShowStatus.Normal)
        {
            this.special = tvShowStatusToString(tv_show_summary.showStatus());
        }
        else
        {
            this.special = "TBA";
            this.episode     = "TBA";//tv_show_summary.episodeTitle();
            //this.season_number = tv_show_summary.seasonNumber();
            //this.episode_number = tv_show_summary.episodeNumber();
            this.episode_id 	 = " ";
            this.episode_url   = tv_show_summary.showUrl();//tv_show_summary.episodeUrl();
        }

        this.network_url   = tv_show_summary.networkUrl();
        this.show_url   = tv_show_summary.showUrl();
        this.image   = tv_show_summary.showImage();
        this.summary   = tv_show_summary.airSummary();
        this.shortinfo   = tv_show_summary.showSummary();

        this.date          = null;
        this.time_is_known = false;
    }
    else
    {
        this.special     = "";
        this.episode     = tv_show_summary.episodeTitle();
        this.season_number = tv_show_summary.seasonNumber();
        this.episode_number = tv_show_summary.episodeNumber();
        this.date        = tv_show_summary.showAirsNext().getTime();
        this.show_url   = tv_show_summary.showUrl();
        this.episode_url   = tv_show_summary.episodeUrl();
        this.network_url   = tv_show_summary.networkUrl();
        this.image   = tv_show_summary.showImage();
        this.summary   = tv_show_summary.airSummary();
        this.shortinfo   = tv_show_summary.showSummary();

        if (tv_show_summary.includesTimeOfDay())
        {
            this.time_is_known = true;
        }
        else
        {
            this.time_is_known = false;
        }
    }
    //this.itunes_id = shows[tv_show_summary.showTitle()];

	scheduleReady();
},

refreshTimezoneOffset: function()
{
   if(this.continent && this.city)
   {
     this.timezone_offset = timezoneDifference(
         '',
         continents[this.continent].cities[this.city].timezone);
   }
   else
   {
     this.timezone_offset = timezoneDifference(
         '',
         continents[DEFAULT_CONTINENT].cities[DEFAULT_CITY].timezone);
   }
},

renderFront: function(odd)
{
	if (this.episode == null)
	{
		// no net connection
		return;
	}

    var front_ul = $('forecast-inner');

	var date = "";

	if (this.date)
	{
		date = formatDate(this);
	}
	else if ($('include-tba-cb').checked == false)
	{
	    return;
	}

    var title   = this.title.replace(/ \(\d\d\d\d\)$/, '');
    var episode = this.episode;

    var days = "";

    if (this.date != null)
    {
		days = this.getDays();

		if (days == -1)
		{
			days = "Yesterday";
		}
		else if (days == 0)
		{
			days = "Today";
		}
		else if (days == 1)
		{
			days = "Tomorrow";
		}
		else if (days < 0)
		{
			days = Math.abs(days) + " days ago";
		}
		else
		{
			days = days + " days";
		}
    }

    var image_div = "";
    var inner_div = "";

    var tv_show_id = this.front_id + '-tv-show';
    var episode_id = this.front_id + '-episode-id';
    var div_id = this.front_id + '-div-id';

    if (this.special == "")
    {
        inner_div = '<div id="' + div_id + '" class="air-date">' + date + '<br/>';
        if(this.getDays() <= 0) inner_div += '<a id="refresh_' + tv_show_id + '" class="refresh"><img src="Images/refresh-button.png"/></a> ';
        inner_div += days + '</div>';
    }
    else
    {
        inner_div = '<div id="' + div_id + '" class="special">' + this.special + '</div>';
    }



    if (this.image != "" && $('include-img-cb').checked == true)
    {
        image_div = '<div id="img' + tv_show_id + '" class="showimage"><img src="' + this.image + '" height="35" width="25"/></div>';
    }
    else if ($('include-img-cb').checked == true)
    {
        image_div = '<div id="img' + tv_show_id + '" class="showimage"><img src="Images/null.png" height="35" width="25"/></div>';
    }

    var li_tag = "";

    if (odd)
    {
        li_tag = '<li id="' + this.front_id + '" class="odd">';
    }
    else
    {
        li_tag = '<li id="' + this.front_id + '" class="even">';
    }

		var episodeText = '-';

		if ($('episode-display-type').value == "ID")
		{
      if (this.season_number && this.episode_number)
			{
				episodeText = 'Season ' + this.season_number + ', Episode ' + this.episode_number;
			}
      else if(this.episode)
			{
				episodeText = this.episode;
			}
      else
			{
				episodeText = '-';
			}
		}
    else if ($('episode-display-type').value == "Both")
		{
			if (this.season_number && this.episode_number && this.episode)
			{
				episodeText = this.season_number + 'x' + ((this.episode_number < 10) ? '0' : '') + this.episode_number + ' - ' + this.episode;
			}
      else if(this.episode)
      {
        episodeText = this.episode;
      }
      else if (this.season_number && this.episode_number)
			{
				episodeText = 'Season ' + this.season_number + ', Episode ' + this.episode_number;
			}
			else
			{
				episodeText = '-';
			}
		}
		else
		{
      if(this.episode)
      {
        episodeText = this.episode;
      }
      else
      {
        episodeText = '-';
      }
		}

    new Insertion.Bottom(
        front_ul,
        li_tag +
        '<div style="clear:left;padding-bottom:4px;height:36px;" />' +
        inner_div +
        image_div +
        '<div class="innerlist">' +
			'<h1><span id="' + tv_show_id + '">' + title + '</span></h1>' +
			'<h2><span id="' + episode_id + '">' + episodeText + '</span></h2>' +
          '</div>' +
      '</li>');

      $(tv_show_id).stopObserving('click');

    if (this.show_url != "" && this.show_url != null)
    {

          Event.observe(
              $(tv_show_id),
              'click',
              function() { widget.openURL(this.show_url); }.bind(this));

        Event.observe(
            $(tv_show_id),
            'mouseover',
            function() { Element.addClassName($(tv_show_id), 'link-hover'); });

        Event.observe(
            $(tv_show_id),
            'mouseout',
            function() { Element.removeClassName($(tv_show_id), 'link-hover'); });
    }
    $(episode_id).stopObserving('click');
    if (this.episode_url != "" && this.episode_url != null)
    {
        Event.observe(
            $(episode_id),
            'click',
            function() { widget.openURL(this.episode_url); }.bind(this));

        Event.observe(
            $(episode_id),
            'mouseover',
            function() { Element.addClassName($(episode_id), 'link-hover'); });

        Event.observe(
            $(episode_id),
            'mouseout',
            function() { Element.removeClassName($(episode_id), 'link-hover'); });
    }


    Event.observe(
        $(div_id),
        'click',
        function()
        {
          $(episode_id).stopObserving('click');

          if($(episode_id).innerHTML != episodeText)
          {
            $(episode_id).innerHTML = episodeText;
            $(tv_show_id).innerHTML = title;
            $(episode_id).stopObserving('click');

            if(this.episode_url != "" && this.episode_url != null)
              Event.observe(
                $(episode_id),
                'click',
                function() { widget.openURL(this.episode_url); }.bind(this));
          }
          else
          {
            $(episode_id).innerHTML = this.summary;
            $(tv_show_id).innerHTML = this.shortinfo;
            $(episode_id).stopObserving('click');
            if(this.network_url != "" && this.network_url != null)
              Event.observe(
                $(episode_id),
                'click',
                function() { widget.openURL(this.network_url); }.bind(this));
          }

         }.bind(this));

      if ($('include-img-cb').checked == true)
      {
             $('img'+tv_show_id).stopObserving('click');

             Event.observe(
                 $('img'+tv_show_id),
                 'click',
                 function()
                 {
                   $(episode_id).stopObserving('click');

                   if($(episode_id).innerHTML != episodeText)
                   {
                     $(episode_id).innerHTML = episodeText;
                     $(tv_show_id).innerHTML = title;
                     $(episode_id).stopObserving('click');
                     if(this.episode_url != "" && this.episode_url != null)
                       Event.observe(
                         $(episode_id),
                         'click',
                         function() { widget.openURL(this.episode_url); }.bind(this));
                   }
                   else
                   {
                     $(episode_id).innerHTML = this.summary;
                     $(tv_show_id).innerHTML = this.shortinfo;
                     $(episode_id).stopObserving('click');
                     if(this.network_url != "" && this.network_url != null)
                       Event.observe(
                         $(episode_id),
                         'click',
                         function() { widget.openURL(this.network_url); }.bind(this));
                   }

                   //widget.openURL(this.show_url);
                 }.bind(this));
      }

      if ($('refresh_' + tv_show_id))
        Event.observe(
          $('refresh_' + tv_show_id),
          'click',
          function() { this.refresh(); }.bind(this));


},

getDate: function()
{
	if (this.date == null || this.date == "")
	{
        return this.date;
	}

    var date = new Date();

    if (this.adjust_for_timezone)
    {
        date.setTime(this.date + (this.timezone_offset * 60 * 1000));
    }
    else
    {
        date.setTime(this.date);
    }

    return date;
},

getDays: function()
{
	if (this.date == null)
	{
		return "Unknown";
	}

    return daysBetween(new Date(), this.getDate());
}
}
